/*** 1.   ũƮ ***/

CREATE TABLE TB_ORFirst (seq INT, date DATETIME)
CREATE TABLE TB_ORSecond (seq INT , gid INT, txt NVARCHAR(36) DEFAULT (NEWID() ) )

INSERT INTO TB_ORFirst 
SELECT ROW_NUMBER() OVER (ORDER BY a.number) seq
	, DATEADD(d, a.number, '2020-01-01') date
FROM master..spt_values a (NOLOCK) ,(SELECT number 
                                     FROM master..spt_values (NOLOCK) 
                                     WHERE type ='p' AND number < 20) b  
WHERE type = 'p'
AND a.number <= 365

INSERT INTO TB_ORSecond
SELECT b.seq, a.number, NEWID()
FROM master..spt_values a (NOLOCK), TB_ORFirst b
WHERE type = 'P'
AND number%2 = 1
AND number <= 100

CREATE CLUSTERED INDEX CIDX_ORFirst ON TB_ORFirst(date)
CREATE INDEX NIDX01_ORSecond ON TB_ORSecond(seq, gid) INCLUDE (txt)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT f.date, s.txt
FROM TB_ORFirst f INNER JOIN TB_ORSecond s
ON f.seq = s.seq 
WHERE f.date BETWEEN '2020-01-01' AND '2020-02-28'
AND s.gid IN (1,2,3,7,8,9,13,14,15,19,20,21,25,26,27,31,32,33)
GO


/*** 6. [TO-BE]   ***/

--(1) IN  ε Ž   ϵ ÷  Ѵ.
SELECT f.date, s.txt
FROM TB_ORFirst f INNER JOIN TB_ORSecond s
ON f.seq = s.seq 
WHERE f.date BETWEEN '2020-01-01' AND '2020-02-28'
AND s.gid + 0 IN (1,2,3,7,8,9,13,14,15,19,20,21,25,26,27,31,32,33)
GO

--HASH  Ͽ ̺ ˻  ּȭѴ.
--ε  
CREATE INDEX NIDX02_ORSecond ON TB_ORSecond(gid) INCLUDE (seq,txt)
GO

-- SQL 
SELECT f.date, s.txt
FROM TB_ORFirst f INNER JOIN TB_ORSecond s
ON f.seq = s.seq 
WHERE f.date BETWEEN '2020-01-01' AND '2020-02-28'
AND s.gid IN (1,2,3,7,8,9,13,14,15,19,20,21,25,26,27,31,32,33)
GO
